#ifndef YOLO_LIB_H
#define YOLO_LIB_H

#include <opencv2/dnn.hpp>
#include <opencv2/imgcodecs.hpp>
#include <opencv2/core/base.hpp>
#include <opencv2/imgproc.hpp>
#include <opencv2/highgui.hpp>
#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <string>
#include <vector>
#include <fstream>
#include <sstream>

// Remove the bounding boxes with low confidence using non-maxima suppression
void post_process(cv::Mat& frame, const std::vector<cv::Mat>& out, float conf_threshold, float nms_threshold, std::vector<std::string> classes, std::vector<cv::Scalar> colors);

// Draw the predicted bounding box
void draw_box(cv::Mat& frame, int classId, float conf, cv::Rect box, std::vector<std::string> classes, std::vector<cv::Scalar> colors);

// Get the names of the output layers
std::vector<cv::String> getOutputsNames(const cv::dnn::Net& net);

// this function is used to get the extension of the file
std::string getFileExt(const std::string& s);

void print_vector(std::vector<std::string> classes);

#endif //YOLO_LIB.H